<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Product $product
 */
?>

<?= $this->Html->css(['product_details']) ?>

<div class="product-details-container">

    <?= $this->Html->link('← Back', ['action' => 'catalogue'], ['class' => 'back-button']) ?>

    <!-- Main Content -->
    <div class="product-main">
        <div class="product-image">
            <img src="<?= $this->Url->image($product->img) ?>" alt="<?= h($product->name) ?>">
        </div>
        <div class="product-info">
            <h1><?= h($product->name) ?></h1>
            <p><strong>Price:</strong> $<?= $this->Number->format($product->price) ?></p>
            <p><strong>Stock:</strong> <?= $this->Number->format($product->stock) ?></p>
            <p><strong>Description:</strong><br><?= h($product->description ?? 'No description available.') ?></p>
        </div>
    </div>

</div>


