<!-- link to stylesheet for faq -->
<?= $this->Html->css(['home', 'faq']) ?>

<!-- Header-->
<header class="py-5" style="position: relative; background-color: #1E1C1A; min-height: 85vh;">
    <div class="container px-5 pb-5 pt-5">
        <div class="row gx-5 align-items-center">
            <div class="col-xxl-5">
                <!-- Header text content-->
                <div class="text-center text-xxl-start">
                    <div class="fs-5 fw-light" style="color: #EADCD4; font-family: 'Inter', sans-serif;"> Welcome to CrunchyCravings </div>
                    <h1 class="display-2 fw-bolder mb-5"><i>Elegance in Every Bite.</i></h1>
                    <div class="d-grid gap-3 d-sm-flex justify-content-sm-center justify-content-xxl-start mb-3">
                        <?= $this->Html->link(
                            '<i class="fas fa-book-open"></i> Our Products',
                            ['controller' => 'Products', 'action' => 'catalogue'],
                            [
                                'class' => 'btn btn-lg px-5 py-3 me-sm-3 fs-6 fw-bolder',
                                'style' => 'background-color: #D4AF37; color: #1E1C1A; border: none;',
                                'escape' => false
                            ]
                        ) ?>
                    </div>
                </div>
            </div>
            <div class="col-xxl-7">
                <!-- Header image -->
                <div class="d-flex justify-content-center mt-5 mt-xxl-0">
                    <div class="rounded shadow" style="overflow: hidden; max-width: 100%; border-radius: 16px;">
                        <?= $this->Html->image('lavosh_home.jpeg', [
                            'alt' => 'Crunchy Lavosh Crackers',
                            'style' => 'width: 100%; height: auto; object-fit: cover; border-radius: 16px;'
                        ]) ?>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Floating Scroll Arrow -->
    <a href="#home-352" class="scroll-down-arrow">
        <i class="fas fa-chevron-down"></i>
    </a>
</header>

<!-- Floating arrow style -->
<style>
    .scroll-down-arrow {
        position: absolute;
        bottom: 20px;
        left: 50%;
        transform: translateX(-50%);
        font-size: 38px;
        color: #D4AF37;
        animation: bounce 1.8s infinite;
        z-index: 100;
        text-decoration: none;
    }

    @keyframes bounce {
        0%, 20%, 50%, 80%, 100% {
            transform: translateX(-50%) translateY(0);
        }
        40% {
            transform: translateX(-50%) translateY(10px);
        }
        60% {
            transform: translateX(-50%) translateY(5px);
        }
    }


</style>

<!-- About Section-->
<section id="home-352" class="py-2">
    <div class="container px-5">
        <div class="row gx-5 justify-content-center">
            <div class="col-xxl-9">
                <div class="text-center my-5">
                    <h2 class="display-5 fw-bolder"><i>About Us</i></h2>
                    <p>
                        From luxurious Lavosh crackers to gourmet hampers,
                        our products will be sure to satisfy your culinary desires or make a perfect gift.
                        Pair our Middle Eastern style crackers with wine or complementary foods for a high-end dining experience.<br><br>
                        Our website platform aims not only to showcase our products, but also to provide a smooth ordering
                        experience for our customers and an easy contact method to facilitate communication between us and you.
                        Peruse our range of handcrafted Lavosh crackers and gift hampers, or
                        <?= $this->Html->link('send us an enquiry', ['controller' => 'ContactForms', 'action' => 'add']) ?>.
                    </p>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- FAQ Section -->
<section id="faq-351" style="background-color: #f3f0e8;" class="py-1">
    <div class="cs-container">
        <div class="cs-content">
<!--            <br>-->
            <h2 class="display-5 fw-bolder"><i>Frequently Asked Questions</i></h2>
        </div>
        <ul class="cs-faq-group">
            <li class="cs-faq-item">
                <button class="cs-button">
                    <span class="cs-button-text">What is a Lavosh cracker?</span>
                </button>
                <p class="cs-item-p">Our Lavosh crackers are a thin, crispy type of flatbread baked to perfection with the finest quality ingredients. Lavosh can be enjoyed with many complementary foods such as wine, dips and cheeses.</p>
            </li>
            <li class="cs-faq-item active">
                <button class="cs-button">
                    <span class="cs-button-text">When will my order be shipped?</span>
                </button>
                <p class="cs-item-p">All deliveries are made between 9:00 am to 5:00pm Monday to Friday. Please allow up to 10 business days for your order to be shipped.</p>
            </li>
            <li class="cs-faq-item active">
                <button class="cs-button">
                    <span class="cs-button-text">Where are you based?</span>
                </button>
                <p class="cs-item-p">We are based in Melbourne, Australia.</p>
            </li>
        </ul>

        <ul class="cs-faq-group">
            <li class="cs-faq-item active">
                <button class="cs-button">
                    <span class="cs-button-text">I would like to place a wholesale order.</span>
                </button>
                <p class="cs-item-p">If you are a wholesale delicatessen supplier or greengrocer store, please contact our team via the enquiries page to make an arrangement.</p>
            </li>
            <li class="cs-faq-item active">
                <button class="cs-button">
                    <span class="cs-button-text">Can I cancel my order?</span>
                </button>
                <p class="cs-item-p">You may cancel orders before they are completed or dispatched.
                    Once an order has been dispatched to you, we are not able to cancel the order or accept returns due to change of mind.
                </p>
            </li>
            <li class="cs-faq-item active">
                <button class="cs-button">
                    <span class="cs-button-text">Do you ship Australia-wide?</span>
                </button>
                <p class="cs-item-p">Yes! You can get our products delivered to any address in Australia.</p>
            </li>
        </ul>
    </div>

    <br><br>

    <script>
        // JavaScript for FAQ toggle
        const faqItems = Array.from(document.querySelectorAll('.cs-faq-item'));
        faqItems.forEach(item => item.classList.remove('active'));
        for (const item of faqItems) {
            item.addEventListener('click', () => {
                item.classList.toggle('active');
            });
        }
    </script>

    <div class="d-flex justify-content-center fs-2 gap-4">
        <a class="text-gradient" href="#!"><i class="bi bi-twitter"></i></a>
        <a class="text-gradient" href="#!"><i class="bi bi-facebook"></i></a>
        <a class="text-gradient" href="#!"><i class="bi bi-instagram"></i></a>
    </div>
</section>
