<?php
$this->assign('title', '400 - Bad Request');
?>

<style>
    .error-wrapper {
        padding: 10px;
        background-color: #1e1c1a;
        color: #f8f8f8;
        text-align: center;
        min-height: 80vh;
    }

    .error-container {
        max-width: 600px;
        margin: auto;
    }

    .error-container h1 {
        font-family: 'Playfair Display', serif;
        font-size: 80px;
        color: rgba(236, 77, 24, 0.87);
        font-weight: bolder;
    }

    .error-container h2 {
        font-family: 'Playfair Display', serif;
        font-size: 30px;
        color: rgb(225, 181, 32);
        font-weight: bolder;
    }

    .error-container p {
        font-size: 18px;
        line-height: 1.6;
        color: #ccc;
        margin: 10px 0;
    }

    .btn {
        display: inline-block;
        padding: 12px 24px;
        margin-top: 30px;
        background-color: #d4af37;
        color: #1E1C1A;
        text-decoration: none;
        border-radius: 6px;
        font-weight: 600;
        transition: background-color 0.2s ease-in-out;
    }

    .btn:hover {
        background-color: #c59e2e;
        color: #000;
    }
</style>

<div class="error-wrapper">
    <div class="error-container">
        <h1>400</h1>
        <h2>Bad Request</h2>
        <p>Oops! It looks like your request couldn’t be processed.</p>
        <p>This might be due to missing parameters, invalid input, or a page that's no longer available.</p>
        <a href="<?= $this->Url->build('/') ?>" class="btn">Back to Home</a>
    </div>
</div>
