<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\ContactForm $contactForm
 */
?>
<style>
    .card {
        border: 2px solid #d4af37;
        border-radius: 12px !important;
        background-color: #fffefb;
        overflow: hidden;
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.08);
    }

    .card-header {
        background-color: #fff8e1;
        border-bottom: 2px solid #d4af37;
        color: #6a4e00;
        font-weight: bold;
        border-top-left-radius: 0 !important;
        border-top-right-radius: 0 !important;
        padding: 1rem 1.25rem;
    }


    .table th,
    .table td {
        border: 2px solid #d4af37 !important;
        color: #333;
    }

    .table th {
        background-color: #fff8e1;
        color: #6a4e00;
    }

    blockquote {
        background-color: #fff8dc;
        border-left: 5px solid #d4af37;
        font-style: italic;
    }

    .btn-secondary {
        background-color: #d4af37;
        color: #1e1c1a;
        font-weight: 600;
        border: none;
    }

    .btn-secondary:hover {
        background-color: #c59e2e;
        color: #000;
    }
</style>

<div class="container mt-4">
    <div class="row justify-content-center">
        <div class="col-md-8">
            <div class="card shadow-lg">
                <div class="card-header text-white">
                    <h3 class="mb-0">Contact Form Details</h3>
                </div>
                <div class="card-body">
                    <table class="table">
                        <tbody>
                            <tr>
                                <th class="w-25">Sender</th>
                                <td><?= h($contactForm->first_name) ?> <?= h($contactForm->last_name) ?></td>
                            </tr>
                            <tr>
                                <th>Email</th>
                                <td><?= h($contactForm->email) ?></td>
                            </tr>
<!--                            <tr>-->
<!--                                <th>ID</th>-->
<!--                                <td>--><?php //= $this->Number->format($contactForm->id) ?><!--</td>-->
<!--                            </tr>-->
                            <tr>
                                <th>Created</th>
                                <td><?= h($contactForm->created) ?></td>
                            </tr>
                        </tbody>
                    </table>
                    <div class="mt-4">
                        <h5 class="text-primary">Enquiry</h5>
                        <blockquote class="blockquote p-3 border rounded bg-light">
                            <?= $this->Text->autoParagraph(h($contactForm->messages)); ?>
                        </blockquote>
                    </div>
                </div>
                <div class="card-footer text-end">
                    <a href="<?= $this->Url->build(['action' => 'index']) ?>" class="btn btn-secondary">Back</a>
                </div>
            </div>
        </div>
    </div>
</div>
