<div id="dateError" style="display:none; color: #b30000; background: #ffe6e6; border: 1px solid #ff9999; padding: 10px 15px; border-radius: 5px; margin-bottom: 15px;">
    <strong>⚠ Error:</strong> 'From Date' cannot be after 'To Date'.
</div>


<?php
/**
 * @var \App\View\AppView $this
 * @var iterable<\App\Model\Entity\ContactForm> $contactForms
 */
?>

<?= $this->Html->css(['manage_inquiries']) ?>

<div class="contactForms index content table-container container-fluid px-5">
    <h1 class="form-title"><?= __('Manage Inquiries') ?></h1>

    <?= $this->Form->create(null, ['type' => 'get', 'onsubmit' => 'return validateDateRange();']) ?>
    <div style="display: flex; justify-content: space-between; align-items: flex-end; flex-wrap: wrap; gap: 10px; margin-bottom: 20px;">
        <div>
            <?= $this->Form->control('date_from', [
                'label' => 'From Date',
                'type' => 'date',
                'value' => $this->request->getQuery('date_from'),
                'id' => 'dateFrom'
            ]) ?>
        </div>
        <div>
            <?= $this->Form->control('date_to', [
                'label' => 'To Date',
                'type' => 'date',
                'value' => $this->request->getQuery('date_to'),
                'id' => 'dateTo'
            ]) ?>
        </div>

        <div>
            <?= $this->Form->button('Search', ['class' => 'btn btn-primary']) ?>
            <?= $this->Html->link('Clear', ['action' => 'index'], ['class' => 'btn btn-secondary']) ?>
        </div>
    </div>
    <?= $this->Form->end() ?>

    <table id="contactFormsTable" class="display table table-hover" style="width: 100%;">
        <thead>
        <tr>
            <th><?= $this->Paginator->sort('last_name', 'Last Name') ?></th>
            <th><?= $this->Paginator->sort('first_name', 'First Name') ?></th>
            <th><?= $this->Paginator->sort('created') ?></th>
            <th><?= $this->Paginator->sort('email') ?></th>
            <th><?= $this->Paginator->sort('phone_number', 'Phone Number') ?></th>
            <th style="min-width: 160px;"><?= $this->Paginator->sort('status', 'Status') ?></th>
            <th class="actions"><?= __('Actions') ?></th>
        </tr>
        </thead>
        <tbody>
        <?php foreach ($contactForms as $contactForm): ?>
            <tr>
                <td><?= h($contactForm->last_name) ?></td>
                <td><?= h($contactForm->first_name) ?></td>
                <td><?= h($contactForm->created->format('d/m/Y, g:i A')) ?></td>
                <td><?= h($contactForm->email) ?></td>
                <td><?= h($contactForm->phone_number) ?></td>
                <td>
                    <?php $status = h($contactForm->status ?? 'Outstanding'); ?>
                    <select class="status-dropdown form-select form-select-sm">
                        <option value="Outstanding" <?= $status === 'Outstanding' ? 'selected' : '' ?>>Outstanding</option>
                        <option value="Responded" <?= $status === 'Responded' ? 'selected' : '' ?>>Responded</option>
                        <option value="Resolved" <?= $status === 'Resolved' ? 'selected' : '' ?>>Resolved</option>
                    </select>
                </td>
                <td>
                    <div class="d-inline-flex p-2">
                        <?= $this->Html->link(__('Details'), ['action' => 'view', $contactForm->id], ['class' => 'btn btn-info mx-2']) ?>
                        <a class="btn btn-dark mx-2" href="mailto:<?= h($contactForm->email) ?>">Email</a>
                        <?= $this->Form->postLink(__('X'),
                            ['action' => 'delete', $contactForm->id],
                            ['confirm' => __("Are you sure you want to delete this message? \nFrom: {0} {1} ({2})",
                                $contactForm->first_name, $contactForm->last_name, $contactForm->email),
                                'class' => 'btn btn-danger mx-2']) ?>
                    </div>
                </td>
            </tr>
        <?php endforeach; ?>
        </tbody>
    </table>
</div>

<<<<<<< HEAD
<style>
    /* Makes dropdown wide enough and pretty */
    .status-dropdown {
        font-weight: bold;
        border-radius: 6px;
        padding: 6px 8px;
        border: 1px solid #d4af37;
        background-color: white;
        transition: background-color 0.3s ease;
        width: 140px;
    }

    /* Color themes for statuses */
    .status-outstanding {
        background-color: #fff3cd;
        color: #856404;
    }

    .status-responded {
        background-color: #d1ecf1;
        color: #0c5460;
    }

    .status-resolved {
        background-color: #d4edda;
        color: #155724;
    }

    /* Hover effect (already provided by .table-hover) */
</style>
=======
>>>>>>> ca02d926f8f982500007219838929a0757cde556

<script>
    function validateDateRange() {
        const from = document.getElementById('dateFrom').value;
        const to = document.getElementById('dateTo').value;
        const errorBox = document.getElementById('dateError');


        if (from && to && new Date(from) > new Date(to)) {
            errorBox.style.display = 'block';
            return false;
        }
        errorBox.style.display = 'none';
        return true;
    }

    document.getElementById('dateTo').addEventListener('change', function() {
        document.getElementById('dateFrom').setAttribute('max', this.value);
    });
    document.getElementById('dateFrom').addEventListener('change', function() {
        document.getElementById('dateTo').setAttribute('min', this.value);
    });

    $(document).ready(function () {
        $('#contactFormsTable').DataTable();

        function applyStatusColor($el) {
            const value = $el.val();
            $el.removeClass('status-outstanding status-responded status-resolved');

            if (value === 'Outstanding') {
                $el.addClass('status-outstanding');
            } else if (value === 'Responded') {
                $el.addClass('status-responded');
            } else if (value === 'Resolved') {
                $el.addClass('status-resolved');
            }
        }

        $('.status-dropdown').each(function () {
            applyStatusColor($(this));
        });

        $('.status-dropdown').on('change', function () {
            applyStatusColor($(this));
        });
    });
</script>

