<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\ContactForm $contactForm
 */
?>

<?= $this->Html->script('resizeCaptcha'); ?>
<?= $this->Html->css(['contactform_add']) ?>


<section class="contact-section py-3">
    <div class="container px-5">
        <!-- Contact form-->
        <div class=" rounded-4 py-5 px-4 px-md-5" style="background-color: #f3f0e8;">
            <div class="text-center mb-5">
                <h1 class="fw-bolder" ><i>Contact Us</i></h1>
                <p class="lead fw-normal text-muted mb-0">Please fill in the following enquiry form. We will get in touch with you soon as we can!</p>
            </div>
            <div class="row gx-5 justify-content-center">
                <div class="col-lg-8 col-xl-6">
                    <!-- * * * * * * * * * * * * * * *-->
                    <!-- * * SB Forms Contact Form * *-->
                    <!-- * * * * * * * * * * * * * * *-->
                    <!-- This form is pre-integrated with SB Forms.-->
                    <!-- To make this form functional, sign up at-->
                    <!-- https://startbootstrap.com/solution/contact-forms-->
                    <!-- to get an API token!-->
                    <?= $this->Form->create($contactForm) ?>
                    <fieldset>

                        <!-- Name input-->

                        <div class="form-floating mb-3">
                            <?php
                            echo $this->Form->control('first_name', ['class' => 'form-control form-control-lg', 'id' => "name", 'placeholder' => 'e.g. John', 'maxLength' => '256']);
                            ?>
                            <!--                            <input class="form-control" id="name" type="text" placeholder="Enter your name..."-->
                            <!--                                   data-sb-validations="required"/>-->
                        </div>
                        <div class="form-floating mb-3">
                            <?php
                            echo $this->Form->control('last_name', ['class' => 'form-control form-control-lg', 'id' => "name", 'placeholder' => 'e.g. Pork', 'maxLength' => '256']);
                            ?>
                            <!--                            <input class="form-control" id="name" type="text" placeholder="Enter your name..."-->
                            <!--                                   data-sb-validations="required"/>-->
                        </div>
                        <!-- Contact details input-->
                        <div class="form-floating mb-3">
                            <?php
                            echo $this->Form->control('email', ['class' => 'form-control form-control-lg', 'id' => "name", 'placeholder' => 'e.g. example@example.com', 'maxLength' => '256']);
                            ?>
                            <!--                            <input class="form-control" id="email" type="email" placeholder="name@example.com"-->
                            <!--                                   data-sb-validations="required,email"/>-->
                            <!--                            <label for="email">Email address</label>-->
                            <!--                            <div class="invalid-feedback" data-sb-feedback="email:required">An email is required.</div>-->
                            <!--                            <div class="invalid-feedback" data-sb-feedback="email:email">Email is not valid.</div>-->
                        </div>
                        <div class="form-floating mb-3">
                            <?= $this->Form->control('phone_number', [
                                'type' => 'tel',
                                'class' => 'form-control form-control-lg',
                                'id' => 'phone_number',
                                'label' => 'Phone Number',
                                'placeholder' => 'e.g. 0412345678',
                                'pattern' => '^04\d{8}$',
                                'title' => 'Phone number must start with 04 and be 10 digits',
                                'required' => true
                            ]) ?>
                        </div>

                        <!-- Phone number input-->
                        <div class="form-floating mb-3">
                            <?php
                            echo $this->Form->control('messages', ['class' => 'form-control form-control-lg', 'id' => "name", 'placeholder' => 'Enter your message...', 'maxLength' => '1024']);
                            ?>
                            <!--                            <input class="form-control" id="phone" type="tel" placeholder="(123) 456-7890"-->
                            <!--                                   data-sb-validations="required"/>-->
                            <!--                            <label for="phone">Phone number</label>-->
                            <!--                            <div class="invalid-feedback" data-sb-feedback="phone:required">A phone number is-->
                            <!--                                required.-->
                            <!--                            </div>-->
                        </div>
                        <!-- Message input-->
                        <!-- Submit success message-->
                        <!---->
                        <!-- This is what your users will see when the form-->
                        <!-- has successfully submitted-->
                        <div class="d-none" id="submitSuccessMessage">
                            <div class="text-center mb-3">
                                <div class="fw-bolder">Form submission successful!</div>
                                To activate this form, sign up at
                                <br/>
                                <a href="https://startbootstrap.com/solution/contact-forms">https://startbootstrap.com/solution/contact-forms</a>
                            </div>
                        </div>
                        <!-- Submit error message-->
                        <!---->
                        <!-- This is what your users will see when there is-->
                        <!-- an error submitting the form-->
                        <div class="d-none" id="submitErrorMessage">
                            <div class="text-center text-danger mb-3">Error sending message!</div>
                        </div>
                        <!-- Submit Button-->
<!--                        <div class="d-grid">-->
<!--                            <button class="btn btn-primary btn-lg disabled" id="submitButton" type="submit">Submit-->
<!--                            </button>-->
<!--                        </div>-->
                    </fieldset>
                    <div class="g-recaptcha" data-sitekey="6LcEYhYrAAAAAMawOAu3hRQcVQX0ug8L8ZtT_pmX"></div>
<!--                    "6Lc6puEqAAAAAPeN7hMxivVmaF_dJqo6j7eFBUCl"-->
                    <div class="d-grid">
                        <?= $this->Form->button(__('Submit'), ['class' => 'btn btn-primary btn-lg my-2']) ?>
                    </div>
                    <?= $this->Form->end() ?>
                </div>
            </div>
        </div>
    </div>
</section>
