<?php
/**
 * @var \App\View\AppView $this
 */

use Cake\Core\Configure;

$debug = Configure::read('debug');

// $this->layout = 'login';
$this->assign('title', 'Login');
?>
<div class="container-fluid" style="background: #f3f0e8; min-height: 100vh; min-width: 300px; display: flex; align-items: center; justify-content: center; padding: 0;">

    <div class="shadow-lg container col-md-auto rounded login-box">
        <div class = "container">
        <?= $this->Flash->render() ?>
        <h3 class="form-label">Login</h3>
        <?= $this->Form->create() ?>
        <fieldset>
            <?= $this->Form->control('email', ['required' => true,'class' => 'form-control form-control-lg my-1' , 'id' => "floatingInputValue", 'placeholder' => 'name@example.com']) ?>
            <?= $this->Form->control('password', ['required' => true,'class' => 'form-control form-control-lg my-1', 'id' => "name", 'placeholder' => 'Enter your password...']) ?>
        </fieldset>
        <div id= 'turnStileError' class="message error hidden" onclick="this.classList.add('hidden');">Please complete the captcha response!</div>
        <div id= "turnStileBox" tabindex="-1" class="cf-turnstile my-2" data-sitekey="0x4AAAAAAA_U6Q5J3m9hRkYk"></div>
        <?= $this->Form->submit(__('Login'),['class' => 'btn btn-primary my-2', 'style'=>'margin-top: 15px']); ?>
<!--        --><?php //= $this->Html->link(
//            '<i class="fas fa-key"></i> Forgot password?',
//            ['controller' => 'Auth', 'action' => 'forgetPassword'],
//            ['class' => 'secondary-button', 'escape' => false]
//        ) ?>

        <?= $this->Form->end() ?>
    </div>
</div>

<?= $this->Html->script('https://challenges.cloudflare.com/turnstile/v0/api.js'); ?>
<?= $this->Html->script('resizeTurnStile'); ?>



