<?php
/**
 * @var \App\View\AppView $this
 */

$this->assign('title', 'Forget Password');
?>

<div class="container login my-5">
    <div class="row">
        <div class="column column-50 column-offset-25">
            <div class="contactForms users form content form-container">
                <?= $this->Form->create() ?>

                <fieldset>
                <?= $this->Html->link('Back to login', ['controller' => 'Auth', 'action' => 'login'], ['class' => 'btn btn-danger my-2']) ?>

                    <legend class="form-title">Forget Password</legend>
                    <?= $this->Flash->render() ?>
                    <p style="padding-inline: 2px">Enter your email address registered with our system below to reset your password: </p>

                    <?php
                    echo $this->Form->control('email', [
                        'type' => 'email',
                        'required' => true,
                        'autofocus' => true,
                        'label' => false,
                        'class' => 'form-control form-control-lg my-1'
                    ]);
                    ?>

                </fieldset>

                <?= $this->Form->button('Send verification email', ['class' => 'btn secondary-button my-2']) ?>

                <?= $this->Form->end() ?>

                <hr class="hr-between-buttons">


            </div>
        </div>
    </div>
</div>
