<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Product $product
 */
?>

<?= $this->Html->css(['product_view']) ?>

    <div class="column column-80">
        <div class="products view content">
            <h1 class="form-title"><?= __('Viewing Product #'), h($product->prod_id), (': '), h($product->name) ?></h1>


            <h4 class="heading"><?= __('Actions') ?></h4>
            <div class="action-buttons">
                <?= $this->Html->link(__('Edit Product'), ['action' => 'edit', $product->prod_id], ['class' => 'side-nav-item']) ?>
                <?= $this->Html->link(__('List Products'), ['action' => 'index'], ['class' => 'side-nav-item']) ?>
                <?= $this->Html->link(__('Add Product'), ['action' => 'add'], ['class' => 'side-nav-item']) ?>
                <?= $this->Form->postLink(__('Delete Product'), ['action' => 'delete', $product->prod_id],
                    ['confirm' => __('Are you sure you want to delete this product? #{0} {1}', $product->prod_id, $product->name),
                        'class' => 'side-nav-item'
                    ]) ?>
            </div>

            <h4 class="heading"><?= __('Product Details') ?></h4>
            <table>
                <tr>
                    <th><?= __('Name') ?></th>
                    <td><?= h($product->name) ?></td>
                </tr>
                <tr>
                    <th><?= __('Image') ?></th>
                    <td>
                        <?php if (!empty($product->img)) : ?>
                            <img src="<?= $this->Url->image($product->img) ?>" alt="<?= h($product->name) ?>" class="product-img">
                        <?php else: ?>
                            <em>No image uploaded</em>
                        <?php endif; ?>
                    </td>
                </tr>
                <tr>
                    <th><?= __('Status') ?></th>
                    <td><?= h($product->status) ?></td>
                </tr>
                <tr>
                    <th><?= __('Sku') ?></th>
                    <td><?= h($product->sku) ?></td>
                </tr>
                <tr>
                    <th><?= __('Brand') ?></th>
                    <td><?= h($product->brand) ?></td>
                </tr>
                <tr>
                    <th><?= __('Product ID') ?></th>
                    <td><?= $this->Number->format($product->prod_id) ?></td>
                </tr>
                <tr>
                    <th><?= __('Price') ?></th>
                    <td><?= __('$'), $this->Number->format($product->price) ?></td>
                </tr>
                <tr>
                    <th><?= __('Stock') ?></th>
                    <td><?= $this->Number->format($product->stock) ?></td>
                </tr>
                <tr>
                    <th><?= __('Created') ?></th>
                    <td><?= h($product->created) ?></td>
                </tr>
                <tr>
                    <th><?= __('Modified') ?></th>
                    <td><?= h($product->modified) ?></td>
                </tr>
            </table>

            <br>

            <h4 class="heading"><?= __('Description') ?></h4>
                <blockquote>
                    <?= $this->Text->autoParagraph(h($product->description)); ?>
                </blockquote>
            </div>

        </div>
    </div>
</div>
