<?php
/**
 * @var \App\View\AppView $this
 * @var iterable<\App\Model\Entity\Product> $products
 */
?>

<?= $this->Html->css(['manage_products']) ?>


<div class="products index content table-container container">

    <h1 class="form-title"><?= __('Manage Products') ?></h1>

    <?= $this->Html->link(__('Add Product'), ['action' => 'add'], ['class' => 'btn btn-primary']) ?>

    <br><br>

    <div class="table-responsive" id="datatable" style="padding: 10px">
        <table>
            <thead>
                <tr>
                    <th><?= $this->Paginator->sort('product ID') ?></th>
                    <th><?= $this->Paginator->sort('name') ?></th>
                    <th><?= $this->Paginator->sort('image') ?></th>
                    <th><?= $this->Paginator->sort('price') ?></th>
                    <th><?= $this->Paginator->sort('stock') ?></th>
                    <th><?= $this->Paginator->sort('status') ?></th>
                    <th><?= $this->Paginator->sort('sku') ?></th>
<!--                    <th>--><?php //= $this->Paginator->sort('brand') ?><!--</th>-->
                    <th><?= $this->Paginator->sort('created') ?></th>
                    <th><?= $this->Paginator->sort('modified') ?></th>
                    <th class="actions"><?= __('Actions') ?></th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($products as $product): ?>
                <tr>
                    <td><?= $this->Number->format($product->prod_id) ?></td>
                    <td><?= h($product->name) ?></td>
                    <td><?=
                        $this->Html->image($product->img, ['width' => '100px', 'height' => '100px'])
                        ?></td>
                    <td><?= $this->Number->format($product->price) ?></td>
                    <td><?= $this->Number->format($product->stock) ?></td>
                    <td><?= h($product->status) ?></td>
                    <td><?= h($product->sku) ?></td>
<!--                    <td>--><?php //= h($product->brand) ?><!--</td>-->
                    <td><?= $product->created->format('d/m/Y') ?></td>
                    <td><?= $product->modified->format('d/m/Y') ?></td>
                    <td class="actions">
                        <?= $this->Html->link(__('View'), ['action' => 'view', $product->prod_id]) ?>
                        <?= $this->Html->link(__('Edit'), ['action' => 'edit', $product->prod_id]) ?>
                        <?= $this->Form->postLink(__('Delete'), ['action' => 'delete', $product->prod_id],
                            ['confirm' => __('Are you sure you want to delete this product? #{0} {1}', $product->prod_id, $product->name)]) ?>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
    <div class="paginator">
        <ul class="pagination">
            <?= $this->Paginator->first('<< ' . __('first')) ?>
            <?= $this->Paginator->prev('< ' . __('previous')) ?>
            <?= $this->Paginator->numbers() ?>
            <?= $this->Paginator->next(__('next') . ' >') ?>
            <?= $this->Paginator->last(__('last') . ' >>') ?>
        </ul>
        <p><?= $this->Paginator->counter(__('Page {{page}} of {{pages}}, showing {{current}} record(s) out of {{count}} total')) ?></p>
    </div>
</div>

<script>
    $(document).ready(function () {
        $('#productsTable').DataTable();
    });
</script>
