<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Product $product
 */
?>

<?= $this->Html->css(['product_edit']) ?>

<div class="row">
    <div class="column column-80">
        <div class="products form content">
            <?= $this->Form->create($product, ['type' => 'file']) ?>
            <fieldset>
                <h1 class="heading"><?= __('Editing Product #'), h($product->prod_id), (': '), h($product->name) ?></h1>
                    <h4 class="heading"><?= __('Actions') ?></h4>
                <div class="action-buttons">
                    <?= $this->Html->link(__('View Product'), ['action' => 'view', $product->prod_id], ['class' => 'side-nav-item']) ?>
                    <?= $this->Html->link(__('List Products'), ['action' => 'index'], ['class' => 'side-nav-item']) ?>
                    <?= $this->Html->link(__('Add Product'), ['action' => 'add'], ['class' => 'side-nav-item']) ?>
<!--                    --><?php //= $this->Form->postLink(__('Delete Product'), ['action' => 'delete', $product->prod_id],
//                        ['confirm' => __('Are you sure you want to delete this product? #{0} {1}', $product->prod_id, $product->name),
//                            'class' => 'side-nav-item'
//                        ]) ?>
                </div>
                <?php
                echo $this->Form->control('name', ['maxlength' => 30]);
                echo $this->Form->control('description', ['rows' => 3, 'maxlength' => 500]);

                if (!empty($product->img)) {
                    echo '<div style="margin-bottom: 10px;"><strong>Current Image:</strong><br>';
                    echo '<img src="<?php= $this->Url->image($product->img) ?>" style="max-height:150px">';
                    echo '</div>';
                }

                echo $this->Form->control('img', [
                    'type' => 'file',
                    'label' => 'Upload Image:',
                    'accept' => 'image/png,image/jpeg,image/jpg,image/webp'
                ]);

                echo $this->Form->control('price', [
                    'type' => 'text',
                    'pattern' => '^\d+(\.\d{1,2})?$',
                    'placeholder' => 'Enter a valid price (e.g., 10 or 10.99)'
                ]);
                echo $this->Form->control('stock', [
                    'type' => 'number',
                    'min' => '0',
                    'step' => '1',
                    'label' => 'Stock'
                ]);
                echo $this->Form->control('status', [
                    'type' => 'select',
                    'options' => [
                        'active' => 'Active',
                        'inactive' => 'Inactive',
                    ],]);
                echo $this->Form->control('sku');
                echo $this->Form->control('brand', [
                    'placeholder' => 'Optional'
                ]);
                ?>
            </fieldset>
            <?= $this->Form->button(__('Submit'), ['class' => 'button']) ?>
            <?= $this->Form->end() ?>
        </div>
    </div>
</div>
