<?php
/**
 * @var \App\View\AppView $this
 * @var iterable<\App\Model\Entity\Product> $products
 */
?>

<?= $this->Html->css(['catalogue']) ?>

<br>
<h1 class="fw-bolder" ><i>Discover Our Lavosh Collection</i></h1>

<!--<div class="product-grid">-->
<!--    --><?php //foreach ($products as $product): ?>
<!--        <div class="product-card">-->
<!--            <img src="--><?php //= $this->Url->image($product->img) ?><!--" alt="--><?php //= h($product->name) ?><!--" class="product-img">-->
<!--            <div class="product-info">-->
<!--                <h5 class="product-title">--><?php //= h($product->name) ?><!--</h5>-->
<!--                <p class="product-price">$--><?php //= $this->Number->format($product->price) ?><!--</p>-->
<!--                --><?php //= $this->Html->link(__('Details'), ['action' => 'details', $product->prod_id], ['class' => 'btn details-btn']) ?>
<!--            </div>-->
<!--        </div>-->
<!--    --><?php //endforeach; ?>
<!--</div>-->

<br><br>
<section id="collection-1602">
    <div class="cs-container">
        <div class="cs-content" style="text-align:center; width:400px; margin:0 auto">
            <div class="cs-button-group">
                <button class="cs-button" data-filter="one">
                    All Products
                </button>
                <button class="cs-button" data-filter="two">
                    Best Selling
                </button>
                <button class="cs-button" data-filter="three">
                    Specials
                </button>
            </div>
        </div>

        <div class="cs-listings-wrapper">
            <!--Listing 1-->
            <div class="cs-listing" data-category="one">
                <?php foreach ($products as $product): ?>
                <div class="cs-item">
                    <a href="<?= $this->Url->build(['action' => 'details', $product->prod_id]) ?>" class="cs-link">
                        <div class="cs-picture-group">
                            <picture class="cs-picture">
                                <source media="(max-width: 600px)"
                                        srcset="<?= $this->Url->image($product->img) ?>">
                                <source media="(min-width: 601px)"
                                        srcset="<?= $this->Url->image($product->img) ?>">
                                <img loading="lazy" decoding="async"
                                     src="<?= $this->Url->image($product->img) ?>"
                                     alt="gallery" width="305" height="400">
                            </picture>
                            <span class="cs-offer">POPULAR</span>
                        </div>
                        <div class="cs-details">
                            <span class="cs-category"><?= h($product->brand) ?></span>
                            <h3 class="cs-name"><?= h($product->name) ?></h3>

                            <div class="cs-actions">
                                <div class="cs-flex">
                                    <span class="cs-price"> $<?= $this->Number->format($product->price) ?> </span>
                                    <img class="cs-basket"
                                         src="https://csimg.nyc3.cdn.digitaloceanspaces.com/Images/Icons/ecomm-bag-icon.svg"
                                         alt="buy" height="24" width="24" loading="lazy" decoding="async">
<!--                                    <span class="cs-was-price">$12.00</span>-->
                                    </div>
                                <?= $this->Html->link(__('Details'), ['action' => 'details', $product->prod_id], ['class' => 'btn details-btn']) ?>

                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
                </div
            </div>
    </div>
</section>

<br>
    <div class="paginator">
        <ul class="pagination">
            <?= $this->Paginator->first('<< ' . __('first')) ?>
            <?= $this->Paginator->prev('< ' . __('previous')) ?>
            <?= $this->Paginator->numbers() ?>
            <?= $this->Paginator->next(__('next') . ' >') ?>
            <?= $this->Paginator->last(__('last') . ' >>') ?>
        </ul>
        <p><?= $this->Paginator->counter(__('Page {{page}} of {{pages}}, showing {{current}} item(s) out of {{count}} total')) ?></p>
    </div>

<script>
    $(document).ready(function () {
        $('#productsTable').DataTable();
    });
</script>

<script>
    class GalleryFilter {
        filtersSelector = ".cs-button";
        imagesSelector = ".cs-listing";
        activeClass = "cs-active";
        hiddenClass = "cs-hidden";

        constructor() {
            const $filters = document.querySelectorAll(this.filtersSelector);
            this.$activeFilter = $filters[0];
            this.$images = document.querySelectorAll(this.imagesSelector);

            this.$activeFilter.classList.add(this.activeClass);

            for (const $filter of $filters) {
                $filter.addEventListener("click", () => this.onClick($filter));
            }
        }

        onClick($filter) {
            this.filter($filter.dataset.filter);

            const { activeClass } = this;

            this.$activeFilter.classList.remove(activeClass);
            $filter.classList.add(activeClass);

            this.$activeFilter = $filter;
        }

        filter(filter) {
            const showAll = filter == "all";
            const { hiddenClass } = this;

            for (const $image of this.$images) {
                const show = showAll || $image.dataset.category == filter;
                $image.classList.toggle(hiddenClass, !show);
            }
        }
    }

    new GalleryFilter();
</script>
