<?php
declare(strict_types=1);

namespace App\Model\Entity;

use Cake\ORM\Entity;

/**
 * Product Entity
 *
 * @property int $prod_id
 * @property string $name
 * @property string|null $description
 * @property string|null $img
 * @property string $price
 * @property int $stock
 * @property string|null $status
 * @property string|null $sku
 * @property string|null $brand
 * @property \Cake\I18n\DateTime|null $created
 * @property \Cake\I18n\DateTime|null $modified
 */
class Product extends Entity
{
    /**
     * Fields that can be mass assigned using newEntity() or patchEntity().
     *
     * Note that when '*' is set to true, this allows all unspecified fields to
     * be mass assigned. For security purposes, it is advised to set '*' to false
     * (or remove it), and explicitly make individual fields accessible as needed.
     *
     * @var array<string, bool>
     */
    protected array $_accessible = [
        'name' => true,
        'description' => true,
        'img' => true,
        'price' => true,
        'stock' => true,
        'status' => true,
        'sku' => true,
        'brand' => true,
        'created' => true,
        'modified' => true,
    ];
}
